Rem
Rem $Header: mqssl_adm_cleanup.sql 19-jan-2007.13:33:34 chall    Exp $
Rem
Rem mqssl_adm_cleanup.sql
Rem
Rem Copyright (c) 2007, Oracle.  All rights reserved.  
Rem
Rem    NAME
Rem      mqssl_adm_cleanup.sql - Removes the Messaging Gateway configuration.
Rem
Rem    DESCRIPTION
Rem      Script to remove Messaging Gateway configured objects used in 
Rem      this sample.
Rem
Rem    NOTES
Rem      WARNING!! This script should be run when the Messaging Gateway 
Rem      agent is running. If the agent is not running, the propagation 
Rem      jobs will not be fully removed until the agent is restarted.
Rem
Rem      The order of removing MGW objects is important. A link cannot be 
Rem      removed until all associated foreign queues have been unregistered.
Rem      A foreign queue cannot be unregistered when propagation jobs, 
Rem      subscribers or schedules reference it.
Rem

connect mgwadm/mgwadm
set serveroutput on

Rem Remove the propagation jobs.

begin
  -- Since this job was for outbound propagation removing it will 
  -- also remove the underlying AQ subscriber.
  dbms_mgwadm.remove_job(job_name => 'job_mqssl_out',
                         force    => dbms_mgwadm.NO_FORCE);
end;
/

begin
  dbms_mgwadm.remove_job(job_name => 'job_mqssl_in',
                         force    => dbms_mgwadm.NO_FORCE);
end;
/

Rem Unregister the MQSeries queue.

begin
  dbms_mgwadm.unregister_foreign_queue(name => 'destq', 
                                       linkname => 'mqssl_link');
end;
/

Rem Finally, remove the link.

begin 
  dbms_mgwadm.remove_msgsystem_link('mqssl_link');
end;
/

Rem Remove the agent Java JSSE properties.

declare
  v_agent varchar2(30) := 'default_agent';
begin
  dbms_mgwadm.remove_option(target_type => dbms_mgwadm.AGENT_JAVA_PROP,
                            target_name => v_agent,
                            option_name => 'javax.net.ssl.trustStore');
  dbms_mgwadm.remove_option(target_type => dbms_mgwadm.AGENT_JAVA_PROP,
                            target_name => v_agent,
                            option_name => 'javax.net.ssl.trustStorePassword');

  dbms_mgwadm.remove_option(target_type => dbms_mgwadm.AGENT_JAVA_PROP,
                            target_name => v_agent,
                            option_name => 'javax.net.ssl.keyStore');
  dbms_mgwadm.remove_option(target_type => dbms_mgwadm.AGENT_JAVA_PROP,
                            target_name => v_agent,
                            option_name => 'javax.net.ssl.keyStorePassword');
end;
/
